<?php

function parseHviData($filepath, $filename) {
    $content = file_get_contents($filepath);
    $rows = explode("\n", $content);

    // IP adrese no faila nosaukuma, piem.: 10.192.2.7_cell1250.hvi
    preg_match('/(\d{1,3}(?:\.\d{1,3}){3})/', $filename, $ipMatch);
    $ipAddress = $ipMatch[1] ?? 'Unknown';

    $parsed = [];

    foreach ($rows as $line) {
        // Formāts piemērā: :D;;001;20190311:114038 DET. D2_11 ----
        if (preg_match('/:(?:D|);;.*?;(\d{8}):(\d{6})\s+(.*?)\s+(.*?)$/', $line, $match)) {
            $date = substr($match[1], 0, 4) . '-' . substr($match[1], 4, 2) . '-' . substr($match[1], 6, 2);
            $time = substr($match[2], 0, 2) . ':' . substr($match[2], 2, 2) . ':' . substr($match[2], 4, 2);
            $code = strtok($match[3], ':');
            $error = trim(substr($match[3], strlen($code) + 1));
            $device = trim($match[4]);

            // Objekta Nr. no iekārtas formāta (piem.: GP1_1 => GP1 + 1)
            $status = '';
            $objectNo = '';
            if (preg_match('/^(\w+)_([0-9]+)([A-Z]*[0-9]*)$/', $device, $devMatch)) {
                $status = $devMatch[1] . $devMatch[3];
                $objectNo = $devMatch[2];
            } else {
                $status = $device;
            }

            $parsed[] = [
                'ip' => $ipAddress,
                'date' => $date,
                'time' => $time,
                'code' => $code,
                'error' => $error,
                'device' => $device,
                'status' => $status,
                'object_no' => $objectNo
            ];
        }
    }

    return $parsed;
}

// Augšupielādes loģika
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['hvi_file'])) {
    $uploadDir = __DIR__ . '/uploads/';
    $uploadFile = $uploadDir . basename($_FILES['hvi_file']['name']);

    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    if (move_uploaded_file($_FILES['hvi_file']['tmp_name'], $uploadFile)) {
        $results = parseHviData($uploadFile, $_FILES['hvi_file']['name']);
    } else {
        echo "<p>Kļūda augšupielādējot failu!</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>HVI Faila Apstrāde</title>
    <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ccc; padding: 6px; }
        th { background-color: #f0f0f0; }
    </style>
</head>
<body>

<h2>Augšupielādēt HVI failu</h2>
<form action="" method="post" enctype="multipart/form-data">
    <input type="file" name="hvi_file" accept=".hvi,.txt" required>
    <button type="submit">Augšupielādēt</button>
</form>

<?php if (!empty($results)): ?>
    <h2>Apstrādātie dati:</h2>
    <table>
        <tr>
            <th>IP adrese</th>
            <th>Datums</th>
            <th>Laiks</th>
            <th>Kods</th>
            <th>Kļūda</th>
            <th>Iekārta</th>
            <th>Statuss</th>
            <th>Objekta Nr</th>
        </tr>
        <?php foreach ($results as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['ip']) ?></td>
            <td><?= htmlspecialchars($row['date']) ?></td>
            <td><?= htmlspecialchars($row['time']) ?></td>
            <td><?= htmlspecialchars($row['code']) ?></td>
            <td><?= htmlspecialchars($row['error']) ?></td>
            <td><?= htmlspecialchars($row['device']) ?></td>
            <td><?= htmlspecialchars($row['status']) ?></td>
            <td><?= htmlspecialchars($row['object_no']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
<?php endif; ?>

</body>
</html>
